<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Logs extends CheckAction {

	public function action_index(){
		$post = self::prepareFilter();
		if (null !== $this->request->post('filter')) {
			$queryCount = DB::select('l.id');
			$queryCount = $this->query($queryCount, $post);
			$total_items = count($queryCount->execute()->as_array(null, 'id'));
		}else{
			$total_items = ORM::factory('Log')->count_all();
		}

		$pagination = Pagination::factory(['total_items' => $total_items]);
		$pagination->items_per_page = 30;
		$queryLogs = DB::select('l.*', 'u.username');
		$queryLogs = $this->query($queryLogs, $post);

		$logs = $queryLogs->limit($pagination->items_per_page)
			->offset($pagination->offset)
			->order_by('id', 'DESC')
			->execute()
			->as_array();

		$users = DB::select('id', 'username')
			->from('users')
			->execute()
			->as_array('id', 'username');

		$model = Model::factory('Log');

		$this->template->content = View::factory('/log/v_index')
			->bind('pagination', $pagination)
			->bind('users', $users)
			->bind('post', $post)
			->bind('model', $model)
			->bind('logs', $logs);
	}

	private function query($query, $post){
		$query = $query->from(['logs', 'l'])
			->join(['users','u'])
			->on('l.user_id', '=', 'u.id');
		/* USERS */
		if (Arr::get($post, 'users')) {
			$query->where('u.id', 'IN', Arr::get($post, 'users'));
		}
		/* START - END */
		if (Arr::get($post, 'date_start') && Arr::get($post, 'date_end')) {
			$start = DB::expr("extract(epoch FROM timestamp '".Arr::get($post, 'date_start')."')");
			$end = DB::expr("extract(epoch FROM timestamp '".Arr::get($post, 'date_end')."' + interval '1' day)");
			$query->where(DB::expr('extract(epoch FROM l.time_start)'), 'BETWEEN', [$start, $end] );
		}
		/* LINK */
		if (Arr::get($post, 'link')){
			$query->where(
				DB::expr("regexp_replace(query::text, '\\\\u0000', '', 'g')::json->>'link'"),
				'ILIKE',
				'%'.Arr::get($post, 'link').'%'
			); // TODO slow, need use sphinx?
		}
		return $query;
	}

	private function prepareFilter(){
		$post = array();
		/* RESET */
		if (null !== $this->request->post('reset')) {
			Session::instance()->delete('filterLogsByUser');
			HTTP::redirect('/logs/page/1');
		}

		/* Save filter and redirect */
		if (Request::POST == $this->request->method() && null !== $this->request->post('filter')) {
			$session = Session::instance();
			$session->set('filterLogsByUser', $this->request->post());
			HTTP::redirect('/logs/page/1');
		}

		/* If isset session set post data */
		if (Session::instance()->get('filterLogsByUser')) {
			$post = Session::instance()->get('filterLogsByUser');
			$this->request->post($post);
		}

		return $post;
	}
}